// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     device/serial/serial.mojom
//

package org.chromium.mojom.device.serial;

class SerialService_Internal {

    public static final org.chromium.mojo.bindings.Interface.Manager<SerialService, SerialService.Proxy> MANAGER =
            new org.chromium.mojo.bindings.Interface.Manager<SerialService, SerialService.Proxy>() {
    
        public String getName() {
            return "device::serial::SerialService";
        }
    
        public int getVersion() {
          return 0;
        }
    
        public Proxy buildProxy(org.chromium.mojo.system.Core core,
                                org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }
    
        public Stub buildStub(org.chromium.mojo.system.Core core, SerialService impl) {
            return new Stub(core, impl);
        }
    
        public SerialService[] buildArray(int size) {
          return new SerialService[size];
        }
    };

    private static final int GET_DEVICES_ORDINAL = 0;
    private static final int CONNECT_ORDINAL = 1;

    static final class Proxy extends org.chromium.mojo.bindings.Interface.AbstractProxy implements SerialService.Proxy {

        Proxy(org.chromium.mojo.system.Core core,
              org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void getDevices(GetDevicesResponse callback) {
            SerialServiceGetDevicesParams _message = new SerialServiceGetDevicesParams();
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    GET_DEVICES_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new SerialServiceGetDevicesResponseParamsForwardToCallback(callback));
        }

        @Override
        public void connect(String path, ConnectionOptions options, org.chromium.mojo.bindings.InterfaceRequest<Connection> connection, org.chromium.mojo.bindings.InterfaceRequest<DataSink> sink, org.chromium.mojo.bindings.InterfaceRequest<DataSource> source, DataSourceClient sourceClient) {
            SerialServiceConnectParams _message = new SerialServiceConnectParams();
            _message.path = path;
            _message.options = options;
            _message.connection = connection;
            _message.sink = sink;
            _message.source = source;
            _message.sourceClient = sourceClient;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(CONNECT_ORDINAL)));
        }

    }

    static final class Stub extends org.chromium.mojo.bindings.Interface.Stub<SerialService> {

        Stub(org.chromium.mojo.system.Core core, SerialService impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                SerialService_Internal.MANAGER, messageWithHeader);
                    case CONNECT_ORDINAL: {
                        SerialServiceConnectParams data =
                                SerialServiceConnectParams.deserialize(messageWithHeader.getPayload());
                        getImpl().connect(data.path, data.options, data.connection, data.sink, data.source, data.sourceClient);
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(org.chromium.mojo.bindings.Message message, org.chromium.mojo.bindings.MessageReceiver receiver) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), SerialService_Internal.MANAGER, messageWithHeader, receiver);
                    case GET_DEVICES_ORDINAL: {
                        SerialServiceGetDevicesParams.deserialize(messageWithHeader.getPayload());
                        getImpl().getDevices(new SerialServiceGetDevicesResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class SerialServiceGetDevicesParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 8;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(8, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        private SerialServiceGetDevicesParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public SerialServiceGetDevicesParams() {
            this(0);
        }
    
        public static SerialServiceGetDevicesParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static SerialServiceGetDevicesParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            SerialServiceGetDevicesParams result = new SerialServiceGetDevicesParams(mainDataHeader.elementsOrVersion);
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            return result;
        }
    }

    static final class SerialServiceGetDevicesResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public DeviceInfo[] devices;
    
        private SerialServiceGetDevicesResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public SerialServiceGetDevicesResponseParams() {
            this(0);
        }
    
        public static SerialServiceGetDevicesResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static SerialServiceGetDevicesResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            SerialServiceGetDevicesResponseParams result = new SerialServiceGetDevicesResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                {
                    org.chromium.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.devices = new DeviceInfo[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        org.chromium.mojo.bindings.Decoder decoder2 = decoder1.readPointer(org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.devices[i1] = DeviceInfo.decode(decoder2);
                    }
                }
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            if (devices == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(devices.length, 8, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < devices.length; ++i0) {
                    encoder1.encode(devices[i0], org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            SerialServiceGetDevicesResponseParams other = (SerialServiceGetDevicesResponseParams) object;
            if (!java.util.Arrays.deepEquals(this.devices, other.devices))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + java.util.Arrays.deepHashCode(devices);
            return result;
        }
    }

    static class SerialServiceGetDevicesResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final SerialService.GetDevicesResponse mCallback;

        SerialServiceGetDevicesResponseParamsForwardToCallback(SerialService.GetDevicesResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_DEVICES_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                SerialServiceGetDevicesResponseParams response = SerialServiceGetDevicesResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.devices);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class SerialServiceGetDevicesResponseParamsProxyToResponder implements SerialService.GetDevicesResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        SerialServiceGetDevicesResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(DeviceInfo[] devices) {
            SerialServiceGetDevicesResponseParams _response = new SerialServiceGetDevicesResponseParams();
            _response.devices = devices;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    GET_DEVICES_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class SerialServiceConnectParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 48;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(48, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String path;
        public ConnectionOptions options;
        public org.chromium.mojo.bindings.InterfaceRequest<Connection> connection;
        public org.chromium.mojo.bindings.InterfaceRequest<DataSink> sink;
        public org.chromium.mojo.bindings.InterfaceRequest<DataSource> source;
        public DataSourceClient sourceClient;
    
        private SerialServiceConnectParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public SerialServiceConnectParams() {
            this(0);
        }
    
        public static SerialServiceConnectParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static SerialServiceConnectParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            SerialServiceConnectParams result = new SerialServiceConnectParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.path = decoder0.readString(8, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                result.options = ConnectionOptions.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.connection = decoder0.readInterfaceRequest(24, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.sink = decoder0.readInterfaceRequest(28, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.source = decoder0.readInterfaceRequest(32, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.sourceClient = decoder0.readServiceInterface(36, false, DataSourceClient.MANAGER);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(path, 8, false);
            encoder0.encode(options, 16, true);
            encoder0.encode(connection, 24, false);
            encoder0.encode(sink, 28, false);
            encoder0.encode(source, 32, false);
            encoder0.encode(sourceClient, 36, false, DataSourceClient.MANAGER);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            SerialServiceConnectParams other = (SerialServiceConnectParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.path, other.path))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.options, other.options))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.connection, other.connection))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.sink, other.sink))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.source, other.source))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.sourceClient, other.sourceClient))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(path);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(options);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(connection);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(sink);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(source);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(sourceClient);
            return result;
        }
    }

}

